%% This is file `czjphyse.cls'  LaTeX2e     Version 2.0 - August 2000   
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Documentclass for Czechoslovak Journal of Physics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{czjphyse}
%% ********************************
%%  INITIAL CODE
%% ********************************
\newcommand\@ptsize{}
\RequirePackage{ifthen}
%% **********************************
%%  DECLARATION OF OPTIONS
%% **********************************
\if@compatibility\else
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\fi
\if@compatibility
  \renewcommand\@ptsize{0}
\else
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\fi
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}  
\if@compatibility\else
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\fi
\if@compatibility\else
\DeclareOption{notitlepage}{\@titlepagefalse}
\fi
\if@compatibility\else
\DeclareOption{onecolumn}{\@twocolumnfalse}
\fi
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
%%
\ExecuteOptions{a4paper,10pt,twoside,onecolumn,final}
\ProcessOptions
\input{size1\@ptsize.clo}
%%
%% ****************************************
%% DOCUMENT LAYOUT
%% ****************************************
%%
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setlength{\headheight}{12pt}
\setlength{\headsep}{17pt}
\setlength{\footskip}{25pt}
\setlength{\topmargin}{27pt}
\setlength{\textwidth}{28cc}
\setlength{\textheight}{41cc}
\setcounter{topnumber}{2}
\renewcommand\topfraction{1}%.7}
\setcounter{bottomnumber}{2}%1}
\renewcommand\bottomfraction{1}%.3}
\setcounter{totalnumber}{4}%3}
\renewcommand\textfraction{.08}%.2}
\renewcommand\floatpagefraction{.85}%.5}
%%
%% ************************************
%% PAGE STYLES
%% ************************************
%%
\def\headauthor#1{\def\@headauthor{#1}}
\def\headtitle#1{\def\@headtitle{#1}}
\def\specialhead#1{\def\@specialhead{#1}}
\newcounter{volume}
\def\evidence#1{\def\@evidence{#1}}
\def\cislo#1{\def\@cislo{#1}}
\def\year#1{\def\@year{#1}
  \setcounter{volume}{#1} \addtocounter{volume}{-1950}
  \def\@volume{\arabic{volume}} }
%%
\def\ps@normalni{%
\def\@oddfoot{\hbox{}{\footnotesize\sffamily Czech.\ J.\ Phys.\ \@volume\
(\@year)}\hfil\rmfamily\@evidence\hfil\thepage}
\def\@evenfoot{\hbox{}{\rmfamily\thepage\hfil\@evidence}\hfil
\footnotesize\sffamily Czech.\ J.\ Phys.\ \@volume\ (\@year)}
\def\@evenhead{\hbox{}\hfil\footnotesize\slshape\@headauthor\hfil}
\def\@oddhead{\hbox{}\hfil\footnotesize\slshape\@headtitle\hfil }  }
%%
\def\ps@zvlastni{%
\def\@oddfoot{\hbox{}{\footnotesize\sffamily Czech.\ J.\ Phys.\ \@volume\
(\@year)}\hfil\rmfamily\@evidence\hfil\thepage}
\def\@evenfoot{\hbox{}{\rmfamily\thepage\hfil\@evidence}\hfil
\footnotesize\sffamily Czech.\ J.\ Phys.\ \@volume\ (\@year)}
\let\@evenhead\@empty
\let\@oddhead\@empty  }
%%
\def\ps@prvni{%
\def\@oddfoot{\hbox{}{\footnotesize\sffamily Czechoslovak Journal of Physics,
Vol.\ \@volume\ (\@year), No.\ \@cislo}\hfill\rmfamily\@evidence\hfill
\thepage}
\def\@evenfoot{\hbox{}{\rmfamily\thepage\hfill\@evidence}\hfill
\footnotesize\sffamily
Czechoslovak Journal of Physics, Vol.\ \@volume\ (\@year), No.\ \@cislo}
\let\@evenhead\@empty
\let\@oddhead\@empty  }
%%
\def\ps@zcelaprvni{%
\def\@oddfoot{\hbox{}{\footnotesize\sffamily Czech.\ J.\ Phys.\ Vol.\ %
\@volume\ (\@year)} \hfil\rmfamily\@evidence\hfil\thepage}
\let\@evenfoot\@empty
\let\@evenhead\@empty
\let\@oddhead\@empty  }
%%
\def\ps@specialni{%
\let\@oddfoot\@empty
\def\@evenfoot{\hbox{}{\rmfamily\thepage\hfil\@evidence}\hfil
{\footnotesize\sffamily Czech.\ J.\ Phys.\ \@volume\ (\@year)}}
\def\@evenhead{\hbox{}\hfil\footnotesize\slshape\@specialhead\hfil}
\let\@oddhead\@empty  }
%%
\def\poslednisuda{\thispagestyle{specialni}}
\def\bezzahlavi{\thispagestyle{zvlastni}}
%%
%% **************************************
%% THE TITLE
%% **************************************
%%
\newcommand{\maketitle}{\newpage \vskip-20pt
 \begingroup
 \renewcommand\thefootnote{\@fnsymbol\c@footnote}                                               
 \def\@makefnmark{\hbox{{$^{\@thefnmark}$)}}}%\hss}}}
 \long\def\@makefntext##1{\parindent 1em\noindent \hb@xt@1.8em{% \newpage
     \hss$^{\@thefnmark}$)}\hspace{2pt}##1}
 \global\@topnum\z@
  \@maketitle
 \thispagestyle{prvni}
 \endgroup
 \setcounter{footnote}{0}
 \let\maketitle\relax
 \let\@maketitle\relax
 \gdef\@author{}\gdef\@title{}
}
%%
\def\pagesfromto#1{\def\@pagesfromto{#1}}
%%
\newcommand{\makefirsttitle}{\newpage
\newcommand{\qx}{\hspace{-1pt}}
{\noindent\LARGE\bfseries C\hspace{-2pt}Z\qx E\qx C\qx H\hspace{-1.5pt}O\qx S%
\qx L\hspace{-1.5pt}O\hspace{-2.5pt}V\hspace{-5.5pt}A\hspace{-2.5pt}K%
\hfill J\qx\qx O\qx\qx U\qx R\qx N\hspace{-2.5pt}A\qx L\hfill O\qx \qx F%
\hfill P\hspace{-2pt}H\qx\qx Y\qx\qx S\qx I\qx\qx C\hspace{-1.5pt}S}\\
\vskip -6pt
\newfont{\tecka}{cmbsy10}
{\noindent Volume \@volume\ {\tecka\symbol{1}} \@year\hfill
Number \@cislo\ {\tecka\symbol{1}} pp.\ \@pagesfromto \\}
\vskip -18pt
\noindent\rule{28cc}{0.9pt}
 \par\begingroup
 \def\thefootnote{\fnsymbol{footnote}}
 \def\@makefnmark{\hbox{{$^{\@thefnmark}$)}}}%\hss}}}
 \long\def\@makefntext##1{\parindent 1em\noindent \hb@xt@1.8em{% \newpage
     \hss$^{\@thefnmark}$)}\hspace{2pt}##1}
 \vskip 35pt \global\@topnum\z@ \@maketitle
 \thispagestyle{zcelaprvni}
 \endgroup
 \setcounter{footnote}{0}
 \let\makefirsttitle\relax
 \let\@maketitle\relax
 \gdef\@author{}\gdef\@title{}
}
%%
\def\authori#1{\def\@authori{#1}}
\def\authorii#1{\def\@authorii{#1}}
\def\authoriii#1{\def\@authoriii{#1}}
\def\addressi#1{\def\@addressi{#1}}
\def\addressii#1{\def\@addressii{#1}}
\def\addressiii#1{\def\@addressiii{#1}}
\def\daterec#1{\def\@daterec{#1}}
%%
\newcommand{\@maketitle}{\null
\vskip-17pt
{\centering
   {\normalfont\bfseries \@title \par} \vskip 1em
   {\lineskip 2em   {\scshape\@authori\par}}
   \medskip
   {\small\slshape \@addressi\par}
   {\setbox\@tempboxa\hbox{\@authorii}
       \ifdim\wd\@tempboxa >0pt
          {\vskip 1em  {\scshape\@authorii\par}
           \medskip
           {\small\slshape \@addressii\par}
           {\setbox\@tempboxa\hbox{\@authoriii}
               \ifdim\wd\@tempboxa >0pt
                  {\vskip 1em  {\scshape\@authoriii\par}
                   \medskip
                   {\small\slshape \@addressiii\par}}
               \else
               \fi}}
       \else
       \fi}   }  %konec cent
\vskip 1em     
{\setbox\@tempboxa\hbox{\@daterec}
   \ifdim \wd\@tempboxa >0pt                      % IF longer than empty:
      {\raggedleft \small Received \@daterec\par} % THEN write.
   \else                                          % ELSE  nic.
   \fi}
 \par
 \vskip 1em
   }
%%
%% *************************************
%% SECTIONS
%% *************************************
%%
\setcounter{secnumdepth}{3}
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand\thepart         {\@Roman\c@part}
\renewcommand\thesection      {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection.\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}
%%
\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
\newcommand\section{\@startsection {section}{1}{\z@}%
                                   {3.5ex \@plus .5ex \@minus .2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\centering\normalfont\bfseries}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\small\bfseries}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {3ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {-0ex \@plus0ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\normalsize\itshape}}
\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\normalfont\normalsize}}
%%                                      
%% *************************************
%% LISTS
%% *************************************
%%
\setlength\leftmargini  {2.5em}
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
 \setlength\leftmarginv  {1em}
 \setlength\leftmarginvi {1em}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\normalfont\bfseries --}
\newcommand\labelitemii{$\m@th\ast$}
\newcommand\labelitemiii{$\m@th\bullet$}
\newcommand\labelitemiv{$\m@th\cdot$}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\normalsize #1}
%%
%% *************************************
%% NEW ENVIRONMENTS
%% ************************************
%%
\newenvironment{abstract}{%
        \small}{

        }
%%
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
%%
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
%%
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
%%
\newcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand\thesection{\@Alph\c@section}}
%%
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand\theequation{\@arabic\c@equation}
%%
%% **************************************
%% FLOATS
%% ************************************
%%
\newcounter{figure}
\renewcommand\thefigure{\@arabic\c@figure}
\def\fps@figure{htbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\small Fig.\ \thefigure.\ }
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
%%
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{htbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\small Table \thetable.\ }
\newenvironment{table}
               {\@float{table}}
               {\end@float}
%%
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
%%
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \begingroup
      \leftskip=0pt plus 1 fil
      \rightskip=-\leftskip
      \parfillskip=\leftskip
      \multiply\parfillskip by 2
   \vskip 10pt
   \setbox\@tempboxa\hbox{\small #1 #2}
   \ifdim \wd\@tempboxa >\hsize   % IF longer than one line:
     \small #1 #2\par             % THEN set as ordinary paragraph.
   \else                          % ELSE  center.
     \hbox to\hsize{\small\hfil\box\@tempboxa\hfil}
   \fi
  \endgroup
  \vskip\belowcaptionskip
}
%%
%% **************************************
%% FONT CHANGING
%% **************************************
%%
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
%%
%% ****************************************
%% TOF, LOF, LOT
%% *****************************************
%%
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{3}
\newcommand\tableofcontents{%
    \section*{\contentsname
        \@mkboth{%
           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
    \@starttoc{toc}%
    }
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\newcommand*\l@section[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{1.0em \@plus\p@}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
%%
\newcommand\listoffigures{%
    \section*{\listfigurename
      \@mkboth{\MakeUppercase\listfigurename}%
              {\MakeUppercase\listfigurename}}%
    \@starttoc{lof}%
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
%%
\newcommand\listoftables{%
    \section*{\listtablename
      \@mkboth{%
          \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure
%%
%% ************************************
%% BIBLIOGRAPHY
%% ************************************
%%
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newenvironment{thebibliography}[1]
     {\section*{\centering\small\normalfont\bfseries References}  
      \small\list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy\clubpenalty4000\widowpenalty4000%
      \sfcode`\.\@m}
     {\ifthenelse{\isodd{\value{page}}}{}{\thispagestyle{specialni}}
      \def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
%%
%% ************************************
%% FOOTNOTES
%% ***********************************
%%
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\newcommand\@makefntext[1]{%
    \parindent 1em\noindent
    \hb@xt@1.8em{\hss$^{\@thefnmark}$)}\hspace{2pt}%
    \footnotesize\rmfamily#1}  %\@makefnmark}#1}
\def\@makefnmark{\hspace{.5pt}\hbox{$^{\@thefnmark}$%  
\hspace{-1pt})}}
%%
%% ******************************************
%% INITIALIZATION
%% *****************************************
%%
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
%%
\pagestyle{normalni}
\pagenumbering{arabic}
%\onecolumn
\frenchspacing
%%
%% *******************************************************
\endinput
%%
%% End of file `czjphyse.cls'.
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Useful abbreviations for commands and environments
% and simple macros
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\nc{\newcommand}
\def\rnc{\renewcommand}
\def\bc{\begin{center}}
\def\ec{\end{center}}
\def\bfl{\begin{flushleft}}
\def\efl{\end{flushleft}}
\def\bfr{\begin{flushright}}
\def\efr{\end{flushright}}
\def\bi{\begin{itemize}}
\def\ei{\end{itemize}}
\def\ben{\begin{enumerate}}
\def\een{\end{enumerate}}
\def\bd{\begin{description}}
\def\ed{\end{description}}
\def\be{\begin{equation}}
\def\ee{\end{equation}}
\def\bea{\begin{eqnarray}}
\def\eea{\end{eqnarray}}
\def\beb{\begin{eqnarray*}}
\def\eeb{\end{eqnarray*}}
\def\ba{\begin{array}}
\def\ea{\end{array}}
\def\bfg{\begin{figure}}
\def\efg{\end{figure}}
\def\bt{\begin{table}}
\def\et{\end{table}}
\def\btu{\begin{tabular}}
\def\etu{\end{tabular}}
\def\bbib#1{\begin{thebibliography}{#1}}
\def\ebib{\end{thebibliography}}
\def\mlc{\multicolumn}
\def\sltcs#1{\setlength{\tabcolsep}{#1}}
\def\slacs#1{\setlength{\arraycolsep}{#1}}
\def\sfrac#1#2{\mbox{$\frac{#1}{#2}$}}
\def\probox#1{\protect\mbox{#1}}
\def\disty{\displaystyle}
\def\I{{\rm i}}
\def\E{{\rm e}}
\def\D{{\rm d}}

% Simple macros:

\def\rlha#1#2{\;\raisebox{-0.5ex}{$\stackrel{_{_{#1}}}
      {\stackrel{\displaystyle\rightleftharpoons}{_{_{#2}}}}$}\;}
\def\lapprox{\,\raisebox{-0.6ex}{$\stackrel
      {\displaystyle{<}}{\sim}$}\,}
\def\gapprox{\,\raisebox{-0.6ex}{$\stackrel
      {\displaystyle{>}}{\sim}$}\,}
\def\lrarrows{\:\raisebox{-0.6ex}{$\stackrel{\displaystyle\leftarrow}
      {\rightarrow}$}\:}
\def\rlarrows{\:\raisebox{-0.6ex}{$\stackrel{\displaystyle\rightarrow}
      {\leftarrow}$}\:}
\def\longlrarrows{\:\raisebox{-0.6ex}{$\stackrel{\displaystyle\longleftarrow}
      {\longrightarrow}$}\:}
\def\longrlarrows{\:\raisebox{-0.6ex}{$\stackrel{\displaystyle\longrightarrow}
      {\longleftarrow}$}\:}
\def\longrlarr#1#2{\,\raisebox{-1ex}{$\stackrel{_{_{#1}}}
      {\stackrel{\displaystyle\longrlarrows}{_{_{#2}}}}$}\,}
\def\longlrarr#1#2{\,\raisebox{-1ex}{$\stackrel{_{_{#1}}}
      {\stackrel{\displaystyle\longlrarrows}{_{_{#2}}}}$}\,}
\def\longrarr#1{\;\raisebox{-0.2ex}{$\stackrel{_{_{#1}}}
      {\longrightarrow}$}\;}
\def\longlarr#1{\;\raisebox{-0.2ex}{$\stackrel{_{_{#1}}}
      {\longleftarrow}$}\;}

% Commands for bold letters and symbols: 
 
% Bold upright:

%\bf  - standard                    normalsize (10pt)
\def\sbf#1{\mbox{\cmbxix#1}}      % small (9pt)
\def\fbf#1{\mbox{\cmbxviii#1}}    % footnotesize  (8pt)
\def\ibf#1{\mbox{\cmbxvii#1}}     % 1st order indexes (7pt)
\def\sibf#1{\mbox{\cmbxvi#1}}     % indexes for small (6pt)
\def\iibf#1{\mbox{\cmbxv#1}}      % 2nd order indexes (5pt)

% Bold math. italic:

\def\bm#1{\mbox{\boldmath$#1$}}   % normalsize
\def\sbm#1{\mbox{\cmmibix#1}}     % small
\def\fbm#1{\mbox{\cmmibviii#1}}   % footnotesize
\def\ibm#1{\mbox{\cmmibvii#1}}    % 1st order indexes (7pt)
\def\sibm#1{\mbox{\cmmibvi#1}}    % indexes for small (6pt)
\def\iibm#1{\mbox{\cmmibv#1}}     % 2nd order indexes (5pt)

% Bold symbols:

\def\bfsy#1{\mbox{\cmbsyx#1}}     % normalsize
\def\sbfsy#1{\mbox{\cmbsyix#1}}   % small
\def\fbfsy#1{\mbox{\cmbsyviii#1}} % footnotesize
\def\ibfsy#1{\mbox{\cmbsyvii#1}}  % 1st order indexes (7pt)
\def\sibfsy#1{\mbox{\cmbsyvi#1}}  % indexes for small (6pt)
\def\iibfsy#1{\mbox{\cmbsyv#1}}   % 2nd order indexes (5pt)

\newfont{\cmbxix}{cmbx9}
\newfont{\cmbxviii}{cmbx8}
\newfont{\cmbxvii}{cmbx7}
\newfont{\cmbxvi}{cmbx6}
\newfont{\cmbxv}{cmbx5}

\newfont{\cmmibix}{cmmib9}
\newfont{\cmmibviii}{cmmib8}
\newfont{\cmmibvii}{cmmib7}
\newfont{\cmmibvi}{cmmib6}
\newfont{\cmmibv}{cmmib5}

\newfont{\cmbsyx}{cmbsy10}
\newfont{\cmbsyix}{cmbsy9}
\newfont{\cmbsyviii}{cmbsy8}
\newfont{\cmbsyvii}{cmbsy7}
\newfont{\cmbsyvi}{cmbsy6}
\newfont{\cmbsyv}{cmbsy5}

%\newfont{\msymx}{msym10}
%\newfont{\msymix}{msym9}
%\newfont{\msymviii}{msym8}
%\newfont{\msymvii}{msym7}
%\newfont{\msymvi}{msym6}
%\newfont{\msymv}{msym5}








